// src/app/api/postgres/max-value/route.ts
import { NextRequest, NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET(request: Request) {
  const { searchParams } = new URL(request.url);
  const deviceId = searchParams.get('deviceId');

  if (!deviceId) {
    return NextResponse.json({ error: 'Missing deviceId parameter' }, { status: 400 });
  }

  try {
    const rawMaxValue = await postgresClient.getDeviceMaxValue(deviceId);

    if (rawMaxValue === null) {
      console.warn(`Max value not found for device ${deviceId}, returning null.`);
       return NextResponse.json({ maxValue: null }); // Indicate absence
    }

    // Ensure the value is treated as a number
    const maxValue = parseFloat(String(rawMaxValue));

    if (isNaN(maxValue)) {
        console.error(`Invalid numeric value received for max_value for device ${deviceId}: ${rawMaxValue}`);
        return NextResponse.json({ error: `Invalid max value format for device ${deviceId}` }, { status: 500 });
    }


    return NextResponse.json({ maxValue });
  } catch (error: any) {
    console.error(`API Route - Failed to fetch max value for device ${deviceId}:`, error);
    return NextResponse.json({ error: `Failed to retrieve max value: ${error.message || error}` }, { status: 500 });
  }
}

