import i18n from 'i18next';
import { initReactI18next } from 'react-i18next';
import enTranslation from './locales/en/translation.json';
import heTranslation from './locales/he/translation.json';
import ruTranslation from './locales/ru/translation.json';
import esTranslation from './locales/es/translation.json';
import arTranslation from './locales/ar/translation.json';

// Only initialize if not already initialized
if (!i18n.isInitialized) {
  i18n
    .use(initReactI18next)
    .init({
      resources: {
        en: {
          translation: enTranslation
        },
        he: {
          translation: heTranslation
        },
        ru: {
          translation: ruTranslation
        },
        es: {
          translation: esTranslation
        },
        ar: {
          translation: arTranslation
        }
      },
      lng: 'he', // default language to Hebrew
      fallbackLng: 'he',
      interpolation: {
        escapeValue: false
      },
      react: {
        useSuspense: false // This is important for SSR
      }
    });
}

export default i18n; 