import { useTranslation } from 'react-i18next';
import { isMobile } from '../lib/platform';

const languages = [
  { code: 'en', name: 'English' },
  { code: 'he', name: 'עברית' },
  { code: 'ru', name: 'Русский' },
  { code: 'es', name: 'Español' },
  { code: 'ar', name: 'العربية' }
];

export default function LanguageSwitcher() {
  const { i18n } = useTranslation();
  const isMobileDevice = isMobile();

  return (
    <div className={`${isMobileDevice ? 'w-full' : 'w-48'}`}>
      <select
        value={i18n.language}
        onChange={(e) => i18n.changeLanguage(e.target.value)}
        className={`w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 ${
          isMobileDevice ? 'text-base' : 'text-sm'
        }`}
      >
        {languages.map((lang) => (
          <option key={lang.code} value={lang.code}>
            {lang.name}
          </option>
        ))}
      </select>
    </div>
  );
} 