export interface TabConfig {
  id: string;
  label: string;
  href: string;
}

export const SUPERUSER_ROLE_ID = 0;
export const ADMIN_ROLE_ID = 1;
export const USER_ROLE_ID = 2;

export const getRoleTabs = (roleId: number): TabConfig[] => {
  switch (roleId) {
    case SUPERUSER_ROLE_ID:
      return [
        {
          id: 'system-dashboard',
          label: 'System Dashboard',
          href: '/dashboard/system'
        },
        {
          id: 'system-administration',
          label: 'System Administration',
          href: '/dashboard/admin'
        },
        {
          id: 'system-notifications',
          label: 'System Notifications',
          href: '/dashboard/system-notifications'
        },
        {
          id: 'settings',
          label: 'Settings',
          href: '/dashboard/settings'
        }
      ];
    case ADMIN_ROLE_ID:
      return [
        {
          id: 'admin-dashboard',
          label: 'Admin Dashboard',
          href: '/dashboard/admin'
        },
        {
          id: 'payment-history',
          label: 'Payment History',
          href: '/dashboard/payments'
        },
        {
          id: 'system-notifications',
          label: 'System Notifications',
          href: '/dashboard/system-notifications'
        },
        {
          id: 'pending-orders',
          label: 'Pending Orders',
          href: '/dashboard/pending-orders'
        },
        {
          id: 'settings',
          label: 'Settings',
          href: '/dashboard/settings'
        }
      ];
    case USER_ROLE_ID:
      return [
        {
          id: 'dashboard',
          label: 'Dashboard',
          href: '/dashboard'
        },
        {
          id: 'payment-history',
          label: 'Payment History',
          href: '/dashboard/payments'
        },
        {
          id: 'order',
          label: 'Order',
          href: '/dashboard/order'
        },
        {
          id: 'notifications',
          label: 'Notifications',
          href: '/dashboard/notifications'
        },
        {
          id: 'settings',
          label: 'Settings',
          href: '/dashboard/settings'
        }
      ];
    default:
      return [];
  }
}; 