import { NextResponse } from 'next/server';
import { postgresClient } from '../../../lib/postgresql-client';

export async function GET(request: Request) {
  const { searchParams } = new URL(request.url);
  const email = searchParams.get('email');
  const uid = searchParams.get('uid');

  if (!email || !uid) {
    return NextResponse.json(
      { error: 'Email and UID are required' },
      { status: 400 }
    );
  }

  try {
    const userData = await postgresClient.getUserData(email, uid);
    return NextResponse.json(userData);
  } catch (error) {
    console.error('Error fetching user data:', error);
    return NextResponse.json(
      { error: 'Failed to fetch user data' },
      { status: 500 }
    );
  }
} 