import { NextResponse } from 'next/server';
export const dynamic = 'force-dynamic';

const API_KEY = process.env.NEXT_PUBLIC_SUMIT_TOKEN as string;
const COMPANY_ID = process.env.NEXT_PUBLIC_SUMIT_COMPANY_ID as string;

export async function POST(request: Request) {
  try {
    const { DateFrom, DateTo, StartIndex = 0, PageSize = 100 } = await request.json();
    if (!API_KEY || !COMPANY_ID) {
      return NextResponse.json({ error: 'Sumit credentials not configured' }, { status: 500 });
    }
    const resp = await fetch('https://api.sumit.co.il/accounting/documents/list/', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json', Accept: 'application/json' },
      body: JSON.stringify({
        Credentials: { CompanyID: COMPANY_ID, APIKey: API_KEY },
        DateFrom,
        DateTo,
        IncludeDrafts: false,
        Paging: { StartIndex, PageSize },
      }),
    });
    const text = await resp.text();
    try {
      const data = JSON.parse(text);
      if (resp.ok) return NextResponse.json(data);
      return NextResponse.json({ error: data?.UserErrorMessage || 'Upstream error', upstream: data }, { status: 502 });
    } catch {
      return NextResponse.json({ error: 'Invalid upstream response', upstream: text }, { status: 502 });
    }
  } catch (e: any) {
    console.error('sumit/list error', e);
    return NextResponse.json({ error: e?.message || 'Failed to list documents' }, { status: 500 });
  }
}


