import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function POST(request: Request) {
  try {
    const { id } = await request.json();
    if (!id) {
      return NextResponse.json({ error: 'Device id is required' }, { status: 400 });
    }
    await postgresClient.query('DELETE FROM user_devices WHERE id = $1', [id]);
    return NextResponse.json({ success: true });
  } catch (error) {
    console.error('Failed to delete user device:', error);
    return NextResponse.json({ error: 'Failed to delete user device' }, { status: 500 });
  }
} 