import React, { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { adminTabs } from '../config/admin-tabs';
import { adminMenu } from './admin-menu';
import { useAuth } from '../hooks/use-auth';
import ResponsiveTabs from './ResponsiveTabs';
import { MobileNavigation } from './MobileNavigation';
import { AdminNavigation } from './AdminNavigation';

export default function AdminMainDashboard() {
  const { t } = useTranslation();
  const tabs = adminTabs;
  const menu = adminMenu;
  const defaultTab = 'dashboard';
  const [activeTab, setActiveTab] = useState(defaultTab);

  const ActiveComponent = tabs.find(tab => tab.id === activeTab)?.component;

  return (
    <div className="flex flex-col min-h-screen">
      {/* Navigation */}
      <AdminNavigation activeTab={activeTab} setActiveTab={setActiveTab} tabs={tabs} menu={menu} />
      {/* Main Content */}
      <main className="flex-1 overflow-x-auto p-1 sm:p-2 md:p-4 pb-20 lg:pb-4 lg:ml-64">
        {/* Desktop Tabs */}
        <div className="hidden lg:block">
          <ResponsiveTabs tabs={tabs} activeTab={activeTab} setActiveTab={setActiveTab} />
        </div>
        {/* Mobile Navigation */}
        <div className="lg:hidden">
          <MobileNavigation tabs={tabs} activeTab={activeTab} setActiveTab={setActiveTab} />
        </div>
        {/* Tab Content */}
        {ActiveComponent && <ActiveComponent />}
      </main>
    </div>
  );
} 